/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, afterEach, spyOn */
'use strict';

// Jasmine Unit Testing Suite
define([ "jquery", "backbone", "marionette", "Portal",
    "loader",
    "jquerymobile", "jasminejquery" ],
    function ($, Backbone, Marionette, Portal) {

        describe("Search Applet: Ward List", function () {
            var view,
                viewEl,
                collection,
                model;

            beforeEach(function () {
                collection = new Backbone.Collection();
                model = new Backbone.Model({
                    patientFilter: "",
                    patientCollection: new Backbone.Collection(),
                    locationFilter: "",
                    locationCollection: collection
                });
                view = new Portal.ListGenerator.WardListView({
                    model: model,
                    collection: collection
                });
                viewEl = view.render().$el;
            });
            afterEach(function() {
                viewEl.remove();
            });

            it("shows a ward in the list", function () {
                view.collection.add(new Portal.ListGenerator.Ward({
                    name: "Recovery"
                }));
                
                var wardEl = viewEl.find('ul li');

                expect(wardEl.length).toEqual(1);
                expect(wardEl.text()).toContain("Recovery");
            });
        });
    });